/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.widget;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.Tooltip;
import org.thinkingstudio.obsidianui.Tooltipable;
import org.thinkingstudio.obsidianui.border.Border;
import org.thinkingstudio.obsidianui.border.EmptyBorder;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceWidget;
import org.thinkingstudio.obsidianui.widget.WithBorder;

public class SpruceLabelWidget
extends AbstractSpruceWidget
implements Tooltipable,
WithBorder {
    public static final Consumer<SpruceLabelWidget> DEFAULT_ACTION = label -> {};
    private final Consumer<SpruceLabelWidget> action;
    private final int maxWidth;
    private int baseX;
    private class_2561 text;
    private List<class_5481> lines;
    private class_2561 tooltip;
    private boolean centered;
    private Border border = EmptyBorder.EMPTY_BORDER;

    public SpruceLabelWidget(Position position, class_2561 text, int maxWidth, Consumer<SpruceLabelWidget> action, boolean centered) {
        super(position);
        this.maxWidth = maxWidth;
        this.baseX = position.getRelativeX();
        this.action = action;
        this.centered = centered;
        this.setText(text);
    }

    public SpruceLabelWidget(Position position, class_2561 text, int maxWidth, Consumer<SpruceLabelWidget> action) {
        this(position, text, maxWidth, action, false);
    }

    public SpruceLabelWidget(Position position, class_2561 text, int maxWidth, boolean centered) {
        this(position, text, maxWidth, DEFAULT_ACTION, centered);
    }

    public SpruceLabelWidget(Position position, class_2561 text, int maxWidth) {
        this(position, text, maxWidth, DEFAULT_ACTION);
    }

    private int getInnerX() {
        return this.getPosition().getAnchor().getX() + this.baseX;
    }

    public class_2561 getText() {
        return this.text;
    }

    public void setText(class_2561 text) {
        this.text = text;
        this.lines = this.client.field_1772.method_1728((class_5348)text, this.maxWidth);
        int width = this.lines.stream().mapToInt(arg_0 -> ((class_327)this.client.field_1772).method_30880(arg_0)).max().orElse(this.maxWidth);
        if (width > this.maxWidth) {
            width = this.maxWidth;
        }
        if (this.isCentered()) {
            this.position.setRelativeX(this.baseX + this.maxWidth / 2 - width / 2);
        } else {
            this.position.setRelativeX(this.baseX);
        }
        this.width = width;
        int n = this.lines.size();
        Objects.requireNonNull(this.client.field_1772);
        this.height = n * 9 + 2;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    @Override
    public Optional<class_2561> getTooltip() {
        return Optional.ofNullable(this.tooltip);
    }

    @Override
    public void setTooltip(@Nullable class_2561 tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
    }

    public void onPress() {
        this.action.accept(this);
    }

    @Override
    public boolean requiresCursor() {
        return this.action == DEFAULT_ACTION;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hovered) {
            this.onPress();
            return true;
        }
        return false;
    }

    @Override
    protected void renderWidget(class_332 graphics, int mouseX, int mouseY, float delta) {
        int y = this.getY() + 2;
        for (class_5481 line : this.lines) {
            int x = this.centered ? this.getInnerX() + this.maxWidth / 2 - this.client.field_1772.method_30880(line) / 2 : this.getInnerX();
            graphics.method_51430(this.client.field_1772, line, x, y, 0xA0A0A0, true);
            y += 9;
        }
        this.getBorder().render(graphics, this, mouseX, mouseY, delta);
        if (this.tooltip != null && !this.tooltip.getString().isEmpty()) {
            List wrappedTooltipText = this.client.field_1772.method_1728((class_5348)this.tooltip, Math.max(this.width / 2, 200));
            if (this.hovered) {
                Tooltip.create(mouseX, mouseY, wrappedTooltipText).queue();
            } else if (this.focused) {
                Tooltip.create(this.getX() - 12, this.getY(), wrappedTooltipText).queue();
            }
        }
    }

    @Override
    protected class_2561 getNarrationMessage() {
        return this.getText();
    }
}

